<?php

// The name of your grid
define("GRID_NAME", "Demo Grid"); // "Demo Grid"

// The plain domain of your grid (without protocol and port)
define("GRID_DOMAIN", "demo.grid.xyz"); // "demo.grid.xyz"

// Define the default language
// code regarding ISO 639-1 (for HTML output)
// or "AUTO" for automatic language detection
define("DEFAULT_LANGUAGE", "AUTO"); // "AUTO", "en", "pt", "es", "fr", "de"

// Chose between direct TPs and an additional description
define("SHOW_DESCRIPTION", TRUE); // TRUE, FALSE

// Relative path to the CSV file
define("CSV_FILE", "data/destinations.csv"); // "data/destinations.csv"

// Relative path to the CSV file
define("CSV_DELIMITER", ","); // ","

// A vertical offset to avoid landing underground after teleporting
define("SLURL_Z_OFFSET", 1); // 1

// Relative path to the style sheets
define("CSS_FILE", "style/destination-guide.css"); // "style/destination-guide.css"

// Relative path to a default image (for missing images)
define("DEFAULT_IMAGE", "style/default-normal.svg"); // "style/default-normal.svg"

// Timezone offset from GMT
define("DEFAULT_TIMEZONE", -8.0); // -8.0 (for SLT)

// Relative path to the cache folder
define("CACHE_FOLDER", "cache"); // "cache"

// Relative path to the image folder
define("IMAGES_FOLDER", "images"); // "images"

// Images output format
define("IMAGES_FORMAT", "JPEG"); // "JPEG", "AUTO", "PNG", "WEBP"

// Toggle interlacing of images
define("IMAGES_INTERLACING", TRUE); // TRUE, FALSE

// JPEG quality
// from 0 (worst) to 100 (best)
// the default (-1) uses the default IJG quality value (about 75)
define("JPEG_QUALITY", -1); // -1

// PNG quality
// from 0 (no compression) to 9
// the default (-1) uses the zlib compression default
define("PNG_QUALITY", -1); // -1

// Toggle cropping of images
define("IMAGES_CROPPING", TRUE); // TRUE, FALSE

?>