<?php
/** RO PHP Destination Guide
 *  Licence: GPLv3, http://www.gnu.org/licenses/gpl-3.0
 *  Author: Torsten Funk <mail@torsten-funk.de>
 */

define("SCRIPT_VERSION", "v1.7.19");

// Error reporting
  // Block everything '0'
  // Show the most '6143'
  // For distribution 'E_ERROR | E_WARNING'
  // For development 'E_ALL'
  error_reporting(E_ERROR | E_WARNING);

// Configuration
include_once('destination-guide.ini.php');

// Functions
include_once('includes/functions.php');

// Language
include_once('languages/en.php');
include_once('includes/language-selector.php');

// flush cache
flushCache();

// Output HTML header
  echo '<!DOCTYPE html>
<HTML lang="'.$language.'">
  <HEAD>
    <link rel="STYLESHEET" href="'.CSS_FILE.'" type="text/css">
    <link rel="shortcut icon" href="favicon.ico" />
    <TITLE>'.GRID_NAME.' Destination Guide</TITLE>
  </HEAD>
  <body>
    <div id="DestinationGuide">';

// Output content
  $Destinations = getCSVasAssocArray();
  $Categories = array_keys($Destinations);
  $countCategories = count($Categories);
  $countDestinations = getCountDestinations($Destinations);
  define('ABOUT_ICON', '<span id="AboutIcon"><a href="?cat=about">?</a></span>');
  //echo $_SERVER['HTTP_USER_AGENT'];
  if (isset($_GET['cat']) && $_GET['cat']=="about")
    showAbout();
  else {
    if (!isset($_GET['cat']) && !isset($_GET['des']))
      showCategories();
    elseif (!isset($_GET['des']))
      showDestinations($_GET['cat']);
    else
      showDescription($_GET['cat'], $_GET['des']); }
// Output HTML bottom
  echo '</div></body>
</html>';
?>