<?php
/** RO PHP Destination Guide
 *  Licence: GPLv3, http://www.gnu.org/licenses/gpl-3.0
 *  Author: Torsten Funk <mail@torsten-funk.de>
 */

function getTeleportButton($cat, $des):string {
  global $Destinations;
  global $L_Teleport;
  $Name = $Destinations[$cat][$des][0];
  $Image = getImage($Destinations[$cat][$des][1]);
  $SLurl = getURL($Destinations[$cat][$des][2]);
  if (SHOW_DESCRIPTION)
    $CSSButton = 'TPButton';
  else
    $CSSButton = 'TPButton switch';
  if ($SLurl!='EMPTY_CSV_CELL') {
    $HRef = 'href="'.$SLurl.'"';
    $Button = $L_Teleport;
    $Style = ''; }
  else {
    $HRef = '';
    $Button = 'No SLurl';
    $Style = 'background-color: red'; }
  // Do NOT add a line break between image and button!!!
  // Otherwise you get a padding-right to the image in the CEF browser of your viewer.
  return '<a '.$HRef.' class="Tile">
            <img src="'.$Image.'" alt="'.$Name.'" />
              <span class="'.$CSSButton.'" style="'.$Style.'">'.$Button.'</span><br>
              '.$Name.'
          </a>'; }

function showDescription($cat, $des):void {
  global $Destinations;
  global $L_Teleport;
  $Name = $Destinations[$cat][$des][0];
  $Image = getImage($Destinations[$cat][$des][1]);
  $SLurl = getURL($Destinations[$cat][$des][2]);
  $Description = $Destinations[$cat][$des][3];
  echo getLocator($cat, $Name, TRUE);
  echo '<div id="Destinations">';
  echo getTeleportButton($cat, $des);
  if ($Description=='EMPTY_CSV_CELL')
        $Description = '';
  echo '<div id="Description">'.$Description.'</div></div>'; }

function showDestinations($Category):void {
  global $Destinations;
  $DestinationsInCategory = $Destinations[$Category];
  echo getLocator($Category, '', TRUE);
  echo '<div id="Destinations">';
  foreach($DestinationsInCategory as $key => $value) {
    if (SHOW_DESCRIPTION) {
      $SLurl = '?cat='.$Category.'&des='.$key;
      $Name = $value[0];
      $Image = getImage($value[1]);
      echo '<a href="'.$SLurl.'" class="Tile">
                <img src="'.$Image.'" alt="'.$Name.'" />&nbsp;<br>
                '.$Name.'
              </a>'; }
    else
      echo getTeleportButton($index); }}

function showCategories():void {
  global $Destinations;
  global $Categories;
  global $countDestinations;
  global $countCategories;
  global $DestinationsDate;
  $previousCategory = '';
  echo getLocator('', '', TRUE);
  echo '<div id="Destinations">';
  $index = 0;
  if ($countCategories>1) {
    while ($index<$countCategories) {
      $Category = $Categories[$index];
      $Image = getImage($Destinations[$Category][0][1]);
      $count = count($Destinations[$Category]);
      $URL = '?cat='.$Category;
      $URL = str_replace(' ', '%20', $URL);
      echo '<a href="'.$URL.'" class="Tile">
              <img src="'.$Image.'" alt="'.$Category.'" /><br>
              '.$Category.' ('.$count.')
            </a>';
      $index++; }}
  echo '</div>'; }

function getCountDestinations():int {
  global $Destinations;
  global $Categories;
  $result = 0;
  foreach($Categories as $Category)
    $result += count($Destinations[$Category]);
  return $result; }

function showAbout():void {
  global $countDestinations;
  global $countCategories;
  global $L_Back;
  global $L_Categories, $L_Destinations, $L_Destinations_updated, $L_Grid_Name,
    $L_Grid_Domain;
  // Define Link for Back-Button
  if (!empty($_SERVER['HTTP_REFERER']))
    $BackURL = $_SERVER['HTTP_REFERER'];
  else
    $BackURL = strtok($_SERVER["REQUEST_URI"], '?');
  // Calculate SLT Date
  $csv_timestamp = filemtime(CSV_FILE) - date('Z') + DEFAULT_TIMEZONE * 3600;
  $DestinationsDate = date("Y-m-d h:i A", $csv_timestamp).' SLT';
  echo getLocator('', '', FALSE);
  echo '<div id="Destinations">
          <div id="Help">
            <a href="'.$BackURL.'" class="Tile">
              <img src="style/icon-normal.svg" alt="" />
              <span class="TPButton">« '.$L_Back.' «</span>
              <br>&nbsp;
            </a>
            <div id="Description">
              <b>RO PHP Destination Guide '.SCRIPT_VERSION.'</b>
              <a href="http://www.pader.world/downloads.html" target="_blank">
                <img src="style/external-link-normal.svg" class="external"
                  alt="http://www.pader.world/downloads.html"
                  title="http://www.pader.world/downloads.html" /></a>
                <br>
              '.$L_Destinations_updated.': '.$DestinationsDate.'<br>
              '.$L_Categories.': '.$countCategories.'<br>
              '.$L_Destinations.': '.$countDestinations.'<br>
              '.$L_Grid_Name.': '.GRID_NAME.'<br>
              '.$L_Grid_Domain.': '.GRID_DOMAIN.'<br>
            </div>
          </div>
        </div>'; }

function getCSVasAssocArray():array {
  global $L_ERROR_Missing_File;
  $array = $fields = array();
  if (is_file(CSV_FILE)) {
    $handle = @fopen(CSV_FILE, "r");
    if ($handle) {
      while (($line = fgetcsv($handle, 2000, CSV_DELIMITER)) !== false) {
        // skip empty lines
        if (empty($fields)) { $fields = $line; continue; }
        // care about empty cells
        foreach($line as &$val) {
          if(empty($val)) { $val = 'EMPTY_CSV_CELL'; }}
        $key = $line[0];
        $v1234 = [$line[1], $line[2], $line[3], $line[4]];
        $array[$key][] = $v1234; }
      if (!feof($handle)) {
          echo "Error: unexpected fgets() fail\n"; }
      fclose($handle);}}
  else {
    echo '<span class="ErrorMessage">'.$L_ERROR_Missing_File.' '.CSV_FILE.'
      </span><br>'; }
  return $array; }

function flushCache():void {
  $TimeFile = '.cachetime';
  if (is_file(CSV_FILE)) {
    $DestinationsTime = filemtime(CSV_FILE);
    if (is_file($TimeFile))
      $CacheTime = filemtime($TimeFile);
    else
      $CacheTime = 1;
    if ($DestinationsTime>$CacheTime) {
      echo '<span class="ErrorMessage">Updated destinations detected, so cache got cleared!</span>';
      emptyDirectory(CACHE_FOLDER);
      $FileHandle = fopen($TimeFile, "w");
      fclose($FileHandle); }}}

function getURL(string $SLurl):string {
/** Possible SLurl formats:
 *  Local: secondlife://Lbsa%20Plaza/137/135/42
 *  HG:    secondlife://hg.osgrid.org:80/Lbsa%20Plaza/137/135/42
 *  V3HG:  secondlife://http|!!hg.osgrid.org|80+Lbsa+Plaza
 *  Hop:   hop://hg.osgrid.org:80/Lbsa%20Plaza/137/135/42
 *  Singularity Viewer (64 bit) 1.8.7 (8193) Feb  7 2020 08:44:28 (Singularity Beta)
 *  x-grid-info://padergrid/region/Welcome%20Area/241/182/27
 */
  if ($SLurl!='EMPTY_CSV_CELL') {
    $search = ["secondlife://", "http|!!", "hop://", "", "x-grid-info://", "region/"];
    $SLurl = str_replace($search, "", $SLurl);
    $pos = strpos($SLurl, "+");
    if ($pos !== false) {
      $SLurl = substr_replace($SLurl, "/", $pos, 1 );
      $SLurl = str_replace("|", ":", $SLurl); }
    $SLurl = str_replace(":", "/", $SLurl);
    $SLurl = str_replace("+", "%20", $SLurl);
    $array = explode("/", $SLurl);
    $pos = strpos($array[0], ".");
    if (!$pos) {
      array_unshift($array, GRID_DOMAIN); }
    $Domain = $array[0];
    $Port = $array[1];
    $appendix = $Domain.':'.$Port;
    if (isset($array[2]))
      $appendix .= ':'.$array[2];
    if (isset($array[3]) && isset($array[4]) &&isset($array[5])) {
      $CoordinateX = $array[3];
      $CoordinateY = $array[4];
      $CoordinateZ = ($array[5]+SLURL_Z_OFFSET);
      $Coordinates = '/'.$CoordinateX.'/'.$CoordinateY.'/'.$CoordinateZ;
      $appendix .= $Coordinates; }
    return 'secondlife:///app/teleport/'.$appendix; }
  else
    return $SLurl; }

function getLocator($Category, $Destination, $About):string {
  global $L_About;
  global $L_Categories;
  $Locator = '<span id="Locator">';
  if (!empty($Category))
    $Locator .= '<a href="destination-guide.php">';
  if ($About)
    $Locator .= $L_Categories;
  else
    $Locator .= $L_About;
  if (!empty($Category))
    $Locator .= '</a>';
  if (!empty($Category)) {
    $Locator .= ' » ';
    if (!empty($Destination))
      $Locator .= '<a href="?cat='.$Category.'">';
    $Locator .= $Category;
    if (!empty($Destination))
      $Locator .= '</a>'; }
  if (!empty($Destination))
    $Locator .= ' » '.$Destination;
  $Locator .= '</span>';
  if ($About)
    $Locator .= ABOUT_ICON;
  return $Locator .= '<hr>'; }

function emptyDirectory($strDir):void {
  // taken from GigKalender
  $strDir .= '/';
  if (is_dir($strDir)) {
    $oDir = dir( $strDir );
    while (false!==($strFile=$oDir->read())) {
      if ($strFile!='.' && $strFile!='..' && !is_link($strDir.$strFile)) {
        if (is_file($strDir.$strFile)) {
          if (@unlink($strDir.$strFile)) {
          }
          else {
            print '<span class="ErrorMessage">ERROR: File NOT deleted! ('.$strFile.')</span><br>'; }}
        else {
          if(is_dir($strDir.$strFile)) {
            emptyDirectory($strDir.$strFile.'/');
            rmdir($strDir.$strFile); }}}}
    $oDir->close(); }}

function getThumbnail($image):string {
  $SourcePath = IMAGES_FOLDER.'/'.$image;
  $basename = pathinfo($image, PATHINFO_FILENAME);
  list($width, $height, $type) = getimagesize($SourcePath);
  $TileWidth = 160;
  $TileHeight = 120;
  if ($width!=$TileWidth AND $height!=$TileHeight) {
    // Load image
    $output = imagecreatetruecolor($TileWidth, $TileHeight);
    switch ($type) {
        case 1 : $source = imageCreateFromGif($SourcePath); break;
        case 2 : $source = imageCreateFromJpeg($SourcePath); break;
        case 3 : $source = imageCreateFromPng($SourcePath); break;
        case 6 : $source = imageCreateFromBmp($SourcePath); break;
        default: echo "ERROR: Unknown inmage format."; }
    // Prepare cropping
    if (IMAGES_CROPPING) {
      // Taken from https://stackoverflow.com/questions/28477241/cropping-any-image-down-to-43-ratio
      $original_aspect = $width / $height;
      $thumb_aspect = $TileWidth / $TileHeight;
      if ($original_aspect >= $thumb_aspect) {
         $new_height = $TileHeight;
         $new_width = $width / ($height / $TileHeight); }
      else {
         $new_width = $TileWidth;
         $new_height = $height / ($width / $TileWidth); }
      // Center the image horizontally
      $x = 0 - ($new_width - $TileWidth) / 2;
      // Center the image vertically
      $y = 0 - ($new_height - $TileHeight) / 2; }
    else { // no cropping
      $x = 0;
      $y = 0;
      $new_width = $TileWidth;
      $new_height = $TileHeight; }
    // Scale image and crop
    imagecopyresampled($output, $source, $x, $y, 0, 0, $new_width, $new_height,
      $width, $height);
    // Enable interlancing
    imageinterlace($output, IMAGES_INTERLACING);
    // Create cache folder if missing
    if (!file_exists(CACHE_FOLDER)) {
      if (!mkdir(CACHE_FOLDER, 0777, true))
        die('ERROR: Failed to create cache folder.'); }
    // Write new image to file
    switch (IMAGES_FORMAT) {
        case "JPEG" :
          $file = CACHE_FOLDER.'/'.$basename.'.jpg';
          if (!imagejpeg($output, $file, JPEG_QUALITY)) {
            die('ERROR: Failed to create cached image ('.$basename.')'); }
          break;
        case "PNG" :
          $file = CACHE_FOLDER.'/'.$basename.'.png';
          if (!imagepng($output, $file, PNG_QUALITY)) {
            die('ERROR: Failed to create cached image ('.$basename.')'); }
          break;
        case "WEBP" :
          $file = CACHE_FOLDER.'/'.$basename.'.webp';
          if (!imagewebp($output, $file)) {
            die('ERROR: Failed to create cached image ('.$basename.')'); }
          break; }
    imagedestroy($output); } // free memory
  else { // image already has correct dimensions
    $file = CACHE_FOLDER.'/'.$image;
    if (!copy($SourcePath, CACHE_FOLDER.'/'.$image))
      echo "ERROR: Failed to copy $image...\n"; }
  return $file; }

function getImage($image):string {
  // is thumbnail present?
  $basename = pathinfo($image, PATHINFO_FILENAME);
  $ArrayOfThumbsWithSameBasename = glob(CACHE_FOLDER.'/'.$basename.'.*');
  if ($ArrayOfThumbsWithSameBasename) { // yes, file is cached
    // is original older?
    $OriginalImage = IMAGES_FOLDER.'/'.$image;
    $ExistingThumb = $ArrayOfThumbsWithSameBasename[0];
    $OriginalDate = @filemtime($OriginalImage);
    $ThumbDate = filemtime($ExistingThumb);
    if ($OriginalDate>$ThumbDate)
      return getThumbnail($image);
    return $ExistingThumb; }
  else { // no, file is NOT cached
    if (is_file(IMAGES_FOLDER.'/'.$image))
      return getThumbnail($image);
    else
      return DEFAULT_IMAGE; }}

?>